/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (15/05/07)
 */   
package com.ejie.p06b.pdf;

import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;

import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.manager.P06BTestManager;
import com.ejie.p06b.pdf.xml.P06BListadoTestXML;
import com.ejie.p06b.util.P06BParametros;
import com.ejie.p06b.xlnet.P06BPerfilUsuario;



/**
 * Clase que gestiona la generacin del pdf
 */
public class P06BListadoTestPDF implements P06BIPDF{
    private static long numeroPDF = 0;
	
	public String getXmlPdf(HttpServletRequest request) {
		String xmlPdf = null;
		try{
			ArrayList listTest = (ArrayList)P06BTestManager.getInstance().selectAll();
			xmlPdf = P06BListadoTestXML.getXml(listTest);
		}catch( Exception e) {
			P06BLog.send(2,"P06BListadoTestPDF", "Error al obtener el XML: "+e.getMessage());
			return null;
		}
		return xmlPdf;
	}

	public String getXsltFichero(HttpServletRequest request) {
		String xsltFichero = null;
    	try {
			//Obtener el idioma
			String idioma = null;
			P06BPerfilUsuario perfilUsuario = (P06BPerfilUsuario) request.getSession().getAttribute(P06BConstantes.P06B_VAR_PERFIL_USUARIO);
			if (perfilUsuario != null){
				P06BLog.send(2,this.getClass().getName() + " - getXsltFichero", "Existe objeto perfilUsuario");
				idioma = perfilUsuario.getIdIdioma();
			}else{
				P06BLog.send(2,this.getClass().getName() + " - getXsltFichero", "NOOOOOO Existe objeto perfilUsuario");
			}
			if (idioma == null || idioma.equals("") ){
				idioma = P06BConstantes.P06B_IDIOMA_ES; //"es"
			}
			P06BLog.send(2,this.getClass().getName() + " - getXsltFichero", "Idioma: "+idioma);
			
			xsltFichero = P06BParametros.getListado("pdf.xsl.listadoTest_"+idioma);
    	}catch( Exception e) {
			P06BLog.send(2,this.getClass().getName() + " - getXsltFichero", "Error al obtener el nombre del xslt: " + e.getMessage());
			return null;
		}
    	return xsltFichero;
	}
}